/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.ErpObjectContainer;
import itx.erp.helper.ErpConfig;
import itx.erp.sales.conf.SalesSettings;
import itx.erp.sales.model.Invoice;
import itx.erp.sales.model.Offer;
import itx.erp.sales.model.OfferLine;
import itx.erp.sales.model.Order;
import itx.erp.sales.model.Vat;
import itx.erp.sales.pdf.OfferPdf;
import itx.erp.sales.service.ArticleService;
import itx.erp.sales.service.InvoiceService;
import itx.erp.sales.service.OfferService;
import itx.erp.sales.service.OrderService;
import itx.erp.sales.validator.OfferValidator;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.ProcUtil;

public class OfferController
extends BaseController {
    protected ErpConfig appConfig;
    protected OfferService offerService;
    protected ArticleService articleService;
    protected SalesSettings salesSettings;
    protected OrderService orderService;
    protected InvoiceService invoiceService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public OfferService getOfferService() {
        return this.offerService;
    }

    public void setOfferService(OfferService offerService) {
        this.offerService = offerService;
    }

    public ArticleService getArticleService() {
        return this.articleService;
    }

    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }

    public SalesSettings getSalesSettings() {
        return this.salesSettings;
    }

    public void setSalesSettings(SalesSettings salesSettings) {
        this.salesSettings = salesSettings;
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public InvoiceService getInvoiceService() {
        return this.invoiceService;
    }

    public void setInvoiceService(InvoiceService invoiceService) {
        this.invoiceService = invoiceService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void searchAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException {
        Integer pageNo = req.getParamInt("pageNo", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", pageNo * this.appConfig.getLimit());
        opts.put("pageSize", this.appConfig.getLimit());
        opts.put("q", req.getParameter("q"));
        QueryResult<Offer> qrs = this.offerService.searchOffers(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("salesSettings", this.salesSettings);
        result.put("offers", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer oid = req.getParamInt("offerId");
        Offer o = this.offerService.readOffer(oid);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("offer", o);
        List<Order> orders = this.orderService.listByOffer(o.getOfferId());
        result.put("orders", orders);
        List<Invoice> invoices = this.invoiceService.listByOffer(o.getOfferId());
        result.put("invoices", invoices);
        req.renderJson(result);
    }

    public void configAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        List<Vat> vats = this.articleService.readVats();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("salesSettings", this.salesSettings);
        result.put("vats", vats);
        result.put("success", true);
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer offerId = req.getParamInt("offerId");
        Offer o = offerId != null ? this.offerService.readOffer(offerId) : new Offer();
        o.setOfferDate(req.getParamDate("offerDate"));
        o.setCustomerId(req.getParamInt("customerId"));
        o.setOfferStatus(req.getParameter("offerStatus"));
        o.setSubject(req.getParameter("subject"));
        o.setComment(req.getParameter("comment"));
        o.setInternalNote(req.getParameter("internalNote"));
        List<KeyValueList> lines = req.getKvl().getList("lines");
        o.getLines().clear();
        int cnt = 0;
        for (KeyValueList l : lines) {
            Vat v;
            String lineType = l.getValue("lineType");
            OfferLine ol = new OfferLine();
            ol.setLineType(lineType);
            ol.setSort(cnt++);
            if ("text".equals(lineType)) {
                ol.setShortDescription(l.getValue("shortDescription"));
                ol.setShortDescription2(l.getValue("shortDescription2"));
            }
            if ("price".equals(lineType)) {
                ol.setShortDescription(l.getValue("shortDescription"));
                ol.setAmount(l.getValueDouble("amount"));
                ol.setVatPercentage(l.getValueDouble("vatPercentage"));
                v = new Vat();
                v.setPercentage(ol.getVatPercentage());
                if (this.salesSettings.inputPriceExclVat()) {
                    ol.setPriceExclVat(l.getValueDouble("price"));
                    ol.setPriceInclVat(v.addVat(ol.getPriceExclVat()));
                } else {
                    ol.setPriceInclVat(l.getValueDouble("price"));
                    ol.setPriceExclVat(v.subtractVat(ol.getPriceInclVat()));
                }
            }
            if ("article".equals(lineType)) {
                ol.setArticleId(l.getValueInt("articleId"));
                ol.setSlotplanPricetypeId(l.getValueInt("pricetypeId"));
                ol.setShortDescription(l.getValue("shortDescription"));
                ol.setAmount(l.getValueDouble("amount"));
                ol.setVatPercentage(l.getValueDouble("vatPercentage"));
                v = new Vat();
                v.setPercentage(ol.getVatPercentage());
                if (this.salesSettings.inputPriceExclVat()) {
                    ol.setPriceExclVat(l.getValueDouble("price"));
                    ol.setPriceInclVat(v.addVat(ol.getPriceExclVat()));
                } else {
                    ol.setPriceInclVat(l.getValueDouble("price"));
                    Double piv = ol.getPriceInclVat();
                    Double pev = v.subtractVat(piv);
                    ol.setPriceExclVat(pev);
                }
            }
            o.getLines().add(ol);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        OfferValidator validator = new OfferValidator();
        if (validator.validate(o)) {
            offerId = this.offerService.saveOffer(o);
            result.put("offerId", offerId);
            result.put("success", true);
        } else {
            result.put("error", true);
            result.put("errors", validator.getErrors());
        }
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer id = req.getParamInt("offerId");
        this.offerService.deleteOffer(id);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void printAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer offerId = req.getParamInt("id");
        Offer o = this.offerService.readOffer(offerId);
        OfferPdf pdf = new OfferPdf(o);
        HttpServletResponse resp = req.getResponse();
        resp.setContentType("application/pdf");
        resp.setHeader("Content-Disposition", "inline; filename=\"offer-" + String.valueOf(offerId) + ".pdf\"");
        ServletOutputStream os = resp.getOutputStream();
        pdf.save((OutputStream)os);
        os.close();
    }

    public void openOfferAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        if (!this.appConfig.isDesktopMode()) {
            throw new InvalidStateException("Not in desktop mode");
        }
        Integer offerId = req.getParamInt("id");
        Offer o = this.offerService.readOffer(offerId);
        OfferPdf pdf = new OfferPdf(o);
        String d = ErpObjectContainer.getInstance().getDataDir() + "/offers";
        File offerDir = new File(d);
        if (!offerDir.exists()) {
            offerDir.mkdir();
        }
        String p = offerDir.getAbsolutePath() + "/offerte-" + String.valueOf(o.getOfferId()) + ".pdf";
        pdf.save(p);
        ProcUtil.openUrlInBrowser(p);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void createOrderAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer offerId = req.getParamInt("offerId");
        Offer of = this.getOfferService().readOffer(offerId);
        Order o = this.orderService.createOrder(of);
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        result.put("success", Boolean.valueOf(true));
        result.put("orderId", o.getOrderId());
        req.renderJson(result);
    }

    public void createInvoiceAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer offerId = req.getParamInt("offerId");
        Offer of = this.getOfferService().readOffer(offerId);
        Invoice i = this.invoiceService.createInvoice(of);
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        result.put("success", Boolean.valueOf(true));
        result.put("invoiceId", i.getInvoiceId());
        req.renderJson(result);
    }
}

